<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\TenantController;
use App\Http\Controllers\Api\ReportsController;
use App\Http\Controllers\Api\CategoryController;
use App\Http\Controllers\Api\LocationController;
use App\Http\Controllers\Api\DashboardController;
use App\Http\Controllers\Api\NotificationController;
use App\Http\Controllers\Api\CashManagementController;
use App\Http\Controllers\Api\DocumentController;
use App\Http\Controllers\Api\Property\PropertyController;
use App\Http\Controllers\Api\Property\PropertyApiController;
use App\Http\Controllers\Api\Property\TransactionController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
 */

Route::any('notLogined', [AuthController::class, 'notLogined'])->name('notLogined');
Route::post('/register', [AuthController::class, 'register']);
Route::post('/login', [AuthController::class, 'login']);

// Route::get('email/verify/send/otp', [AuthController::class, 'requestOtp']);
// Route::post('email/verified/otp', [AuthController::class, 'verifyOtp']);

// Route::group(['prefix' => 'auth'], function () {
//     Route::post('/register', [AuthController::class, 'register'])->name('register');
//     Route::post('/login', [AuthController::class, 'login'])->name('login');
// });

// Route::group(['prefix' => 'auth'], function () {

Route::get('email/send/otp', [AuthController::class, 'requestOtp']);
Route::post('email/verified/otp', [AuthController::class, 'verifyOtp']);

Route::post('email/forgot-password', [AuthController::class, 'forgetPassword']);
Route::post('email/reset-password', [AuthController::class, 'resetPassword']);

Route::middleware('auth:sanctum')->group(function () {

    Route::post('/profile-update', [AuthController::class, 'profileUpdate']);

    Route::get('/user', [AuthController::class, 'user']);

    // Route::post('/profile-update', [AuthController::class, 'profileUpdate']);
    Route::post('/change-password', [AuthController::class, 'changePassword']);

    Route::group(['prefix' => 'property'], function () {
        Route::get('/list', [PropertyApiController::class, 'index'])->name('properties.list');
        Route::get('/create', [PropertyApiController::class, 'create'])->name('properties.create');
        Route::get('/info-list', [PropertyApiController::class, 'infoList'])->name('tenants.infoList');
        Route::get('{id}/details-list', [PropertyApiController::class, 'detailsList'])->name('properties.index');
        Route::get('{id}/details/{type}', [PropertyApiController::class, 'details'])->name('properties.api.index'); //api/property/1/details/basic
        // store
        Route::post('/store', [PropertyApiController::class, 'store'])->name('properties.store');

        // edit
        Route::get('/edit/{id}/basicinfo', [PropertyApiController::class, 'edit'])->name('properties.edit');
        // property update
        Route::post('/update/{id}/basicinfo', [PropertyApiController::class, 'update'])->name('properties.update');

        // gallery add
        Route::post('/gallery-floorplan/store', [PropertyApiController::class, 'galleryFloorplanStore'])->name('properties.galleryFloorplan.store');

        // facility edit
        Route::get('/facility/edit/{id}', [PropertyApiController::class, 'facilityEdit'])->name('properties.facility.edit');
        // facility update
        Route::post('/facility/update/{id}', [PropertyApiController::class, 'facilityUpdate'])->name('properties.facility.update');

    });

    Route::group(['prefix' => 'tenant'], function () {
        Route::get('/',                             [TenantController::class, 'index'])->name('tenants.index');
        Route::post('/store',                       [TenantController::class, 'store'])->name('tenants.store');
        Route::get('/create',                       [TenantController::class, 'create'])->name('tenants.create');
        Route::get('{id}/details-list',             [TenantController::class, 'detailsList'])->name('tenants.index');

        // edit
        Route::get('/edit/{id}/{slug}',             [TenantController::class, 'edit'])->name('tenants.edit');
        // tenant update
        Route::post('/update/{id}/{slug}',          [TenantController::class, 'update'])->name('tenants.update');
        Route::post('/delete/{id}/{slug}',          [TenantController::class, 'delete'])->name('tenants.delete');

        Route::get('/info-list',                    [TenantController::class, 'infoList'])->name('tenants.infoList');
        Route::get('{id}/details/{type}',           [TenantController::class, 'details'])->name('tenants.index'); //api/property/1/details/basic
    });

    Route::group(['prefix' => 'dashboard'], function () {
        Route::get('/', [DashboardController::class, 'index'])->name('tenants.index');
        Route::get('{id}/details/{type}', [PropertyController::class, 'details'])->name('tenants.index'); //api/property/1/details/basic

    });

    Route::group(['prefix' => 'transaction'], function () {
        Route::get('/', [TransactionController::class, 'index'])->name('transaction.index');
        Route::get('/{id}/list', [TransactionController::class, 'list'])->name('transaction.list');
        Route::post('/store', [TransactionController::class, 'store'])->name('transaction.store');
        Route::get('/create', [TransactionController::class, 'create'])->name('transaction.create');
        Route::get('/details/{id}', [TransactionController::class, 'details'])->name('transaction.details');

    });

    Route::group(['prefix' => 'notifications'], function () {
        Route::get('/', [NotificationController::class, 'index'])->name('notifications.index');

    });

    Route::group(['prefix' => 'documents'], function () {
        Route::any('/', [DocumentController::class, 'index'])->name('documents.index');
        Route::any('/assets', [DocumentController::class, 'assets'])->name('documents.assets');
        Route::post('/store', [DocumentController::class, 'store'])->name('documents.store');

    });
    Route::group(['prefix' => 'cash-management'], function () {
        Route::get('/list', [CashManagementController::class, 'list'])->name('cashManagement.list');

    });

    Route::group(['prefix' => 'categories'], function () {
        Route::get('/', [CategoryController::class, 'list'])->name('categories.list');

    });
    Route::group(['prefix' => 'reports'], function () {
        Route::get('/properties', [ReportsController::class, 'properties'])->name('reports.properties');
        Route::get('/property-wise-tenants/{id}', [ReportsController::class, 'propertyWiseTenants'])->name('reports.propertyWiseTenants');
        Route::post('/search', [ReportsController::class, 'search'])->name('reports.search');

    });




    // Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    //     return $request->user();
    // });

    // locations

    Route::get('countries', [LocationController::class, 'getCountries']);
    Route::post('divisions', [LocationController::class, 'getDivision']);
    Route::post('districts', [LocationController::class, 'getdistricts']);
    // Route::post('area', [LocationController::class, 'getArea']);

    // Route::get('cities', [LocationController::class, 'getCities']);
});
