@extends('backend.master')
@section('title')
    {{ @$data['title'] }}
@endsection
@section('content')
    <div class="page-content">
        <!-- profile content start -->
        <div class="profile-content">
            <div class="d-flex flex-column flex-lg-row gap-4 gap-lg-0">
                <!-- profile menu mobile start -->
                <div class="profile-menu-mobile">
                    <button class="btn-menu-mobile" type="button" data-bs-toggle="offcanvas"
                        data-bs-target="#offcanvasWithBothOptionsMenuMobile"
                        aria-controls="offcanvasWithBothOptionsMenuMobile">
                        <span class="icon"><i class="fa-solid fa-bars"></i></span>
                    </button>

                    <div class="offcanvas offcanvas-start" data-bs-scroll="true" tabindex="-1"
                        id="offcanvasWithBothOptionsMenuMobile">
                        <div class="offcanvas-header">
                            <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close">
                                <span class="icon"><i class="fa-solid fa-xmark"></i></span>
                            </button>
                        </div>
                       <div class="offcanvas-body">
                            <!-- profile menu start -->
                            <div class="profile-menu">
                                <!-- profile menu head start -->
                                @include('backend.partials.user_profile-menu')
                                <!-- profile menu head end -->

                                <!-- profile menu body start -->
                                <div class="profile-menu-body">
                                    @include('backend.partials.profile_nav')

                                </div>
                                <!-- profile menu body end -->
                            </div>
                            <!-- profile menu end -->
                        </div>
                    </div>
                </div>
                <!-- profile menu mobile end -->


                <!-- profile menu start -->
                <div class="profile-menu">
                    <!-- profile menu head start -->
                    @include('backend.partials.user_profile-menu')
                    <!-- profile menu head end -->

                    <!-- profile menu body start -->
                    <div class="profile-menu-body">
                       @include('backend.partials.profile_nav')
                    </div>
                    <!-- profile menu body end -->
                </div>
                <!-- profile menu end -->

                <!-- profile body start -->
                <div class="profile-body ">
                    <div class="emergency-header-edit edit-section">
                        <h2 class="m-0">{{ _trans('landlord.Account')}}</h2>

                        <a href="#" class="add-edit-btn">
                            <i class="fa-solid fa-edit"></i>
                        </a>
                    </div>
                    <!-- profile body nav end -->
                    <!-- profile body form start -->
                    <div class="profile-body-form load-data">

                        <div class="form-item">
                            <div class="d-flex justify-content-between align-content-center">
                                <div class="align-self-center">
                                    <h2 class="title">{{ _trans('landlord.Account No')}} <span class="fillable">*</span></h2>
                                    <p class="paragraph">{{ @$account->account_number }}</p>
                                </div>
                            </div>
                        </div>

                        <div class="form-item">
                            <div class="d-flex justify-content-between align-content-center">
                                <div class="align-self-center">
                                    <h2 class="title">{{ _trans('landlord.Account Holder Name')}} <span class="fillable">*</span></h2>
                                    <p class="paragraph">{{ @$account->account_name }}</p>
                                </div>
                            </div>
                        </div>

                        <div class="form-item">
                            <div class="d-flex justify-content-between align-content-center">
                                <div class="align-self-center">
                                    <h2 class="title">{{ _trans('landlord.Bank Name')}} <span class="fillable">*</span></h2>
                                    <p class="paragraph">{{ @$account->name }}</p>
                                </div>
                            </div>
                        </div>

                        <div class="form-item">
                            <div class="d-flex justify-content-between align-content-center">
                                <div class="align-self-center">
                                    <h2 class="title">{{ _trans('landlord.Branch Name')}} <span class="fillable">*</span></h2>
                                    <p class="paragraph">{{ @$account->branch }}</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card ot-card mb-24 update-data">
                        <form action="{{ route('users.profileDetailsStore',[$data['id'], 'accounts']) }}" enctype="multipart/form-data" method="post"
                            id="visitForm">
                            @csrf
                            <div class="row mb-3">
                                <div class="col-md-6 mb-3">
                                    <label for="exampleDataList" class="form-label ">{{ _trans('landlord.Account No') }} <span
                                            class="fillable">*</span></label>
                                    <input class="form-control ot-input @error('account_number') is-invalid @enderror"
                                        name="account_number" value="{{ @$account->account_number }}" list="datalistOptions"
                                        id="exampleDataList" placeholder="Enter Name">
                                    @error('account_number')
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="exampleDataList" class="form-label ">{{ _trans('landlord.Account Holder Name') }} <span
                                            class="fillable">*</span></label>
                                    <input class="form-control ot-input @error('account_name') is-invalid @enderror"
                                        name="account_name" value="{{ @$account->account_name }}" list="datalistOptions"
                                        id="exampleDataList" placeholder="Enter account_name">
                                    @error('account_name')
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="exampleDataList" class="form-label ">{{ _trans('landlord.Bank Name') }} <span
                                            class="fillable">*</span></label>
                                    <input class="form-control ot-input @error('name') is-invalid @enderror"
                                        name="name" value="{{ @$account->name }}" list="datalistOptions"
                                        id="exampleDataList" placeholder="Enter name">
                                    @error('name')
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="exampleDataList" class="form-label ">{{ _trans('landlord.Branch Name') }} <span
                                            class="fillable">*</span></label>
                                    <input class="form-control ot-input @error('branch') is-invalid @enderror"
                                        name="branch" value="{{ @$account->branch }}" list="datalistOptions"
                                        id="exampleDataList" placeholder="Enter branch">
                                    @error('branch')
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-12 mt-3">
                                <div class="text-end">
                                    <button class="btn btn-lg ot-btn-primary"><span><i class="fa-solid fa-save"></i>
                                        </span>{{ _trans('landlord.submit') }}</button>
                                </div>
                            </div>
                        </form>

                    </div>

                </div>
            </div>
            <!-- profile body form end -->
        </div>
        <!-- profile body end -->
    </div>
    </div>
@endsection

@push('script')
    @include('backend.partials.delete-ajax')
@endpush
